/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.tileentity;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class InventoryTileEntity
extends TileEntity {
    protected IItemHandlerModifiable itemHandler = this.createInventory();
    private final LazyOptional<IItemHandlerModifiable> inventory = LazyOptional.of(() -> this.itemHandler);
    protected boolean saveInventory = true;

    public InventoryTileEntity(TileEntityType<? extends InventoryTileEntity> tileEntityType) {
        super(tileEntityType);
    }

    public abstract IItemHandlerModifiable createInventory();

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.saveInventory) {
            this.inventory.ifPresent(handler -> {
                if (handler instanceof INBTSerializable) {
                    CompoundNBT inv = (CompoundNBT)((INBTSerializable)handler).serializeNBT();
                    nbt.func_218657_a("inventory", (INBT)inv);
                }
            });
        }
        this.write(nbt);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (this.saveInventory) {
            this.inventory.ifPresent(handler -> {
                if (handler instanceof INBTSerializable) {
                    CompoundNBT inv = nbt.func_150297_b("inventory", 10) ? nbt.func_74775_l("inventory") : new CompoundNBT();
                    ((INBTSerializable)handler).deserializeNBT((INBT)inv);
                }
            });
        }
        this.read(nbt);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    public void fill(Supplier<ItemStack> itemSupplier) {
        this.inventory.ifPresent(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = (ItemStack)itemSupplier.get();
                if (!handler.isItemValid(i, stack)) continue;
                handler.setStackInSlot(i, stack);
            }
        });
    }

    public void consumeItem(int id) {
        this.inventory.ifPresent(handler -> handler.getStackInSlot(id).func_190918_g(1));
    }

    public void clear() {
        this.fill(() -> ItemStack.field_190927_a);
    }

    public boolean isEmpty() {
        LazyOptional<IItemHandlerModifiable> inv = this.getInventory();
        if (inv.isPresent()) {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)inv.orElse(null);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public LazyOptional<IItemHandlerModifiable> getInventory() {
        LazyOptional capability = this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        return capability.cast();
    }

    public void write(CompoundNBT nbt) {
    }

    public void read(CompoundNBT nbt) {
    }
}

